/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8238.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8238.DeviceView.Builder;
import ibm.nways.jdm8238.DeviceView.BuilderLike;
import ibm.nways.jdm8238.DeviceView.ChassisInfoLike;
import ibm.nways.jdm8238.DeviceView.ChassisLike;
import ibm.nways.jdm8238.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8238.DeviceView.PortLike;
import ibm.nways.jdm8238.DeviceView.TrunkModuleLike;
import ibm.nways.jdm8238.DeviceView.TrunkPortLike;
import ibm.nways.ras.RAS;
import java.awt.Point;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class TrunkModule
implements TrunkModuleLike {
    protected String backgroundGif = "";
    protected GraphicImage trunkGraphicImage;
    protected int trunkType;
    protected int trunkSlotIndex;
    protected int trunkIndex;
    protected Point location;
    protected GraphicContainer graphicContainer;
    protected GraphicContainer trunkContainer = new GraphicContainer();
    private Vector components = new Vector();
    private BuilderLike builder = Builder.getInstance();
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8238.DeviceView.GraphicResources";
    protected static ResourceBundle resources = ResourceBundle.getBundle("ibm.nways.jdm8238.DeviceView.GraphicResources");
    protected static final String SER_PATH = "ibm.nways.jdm8238.WCDefault";
    protected static final String DEST_PANEL = "ibm.nways.jdm8238.eui.TrunkPanel";
    protected static final int COOKIE_FLAGS = 20;
    protected String cookieID;
    protected ModelInfo trunkInfo;
    protected GenModel trunkTableModel;
    protected GenModel portTableModel;
    protected JdmBrowser jdmBrowser;
    protected ChassisLike chassis;
    protected ChassisInfoLike chassisInfo;
    public static final int BACKPLANE = 1;
    public static final int FIBER = 5;
    public static final int RJ45S = 9;
    public static final int INTRASTACK = 25;

    public void dispose() {
        if (this.graphicContainer != null) {
            this.graphicContainer.dispose();
            this.graphicContainer = null;
        }
        if (this.trunkContainer != null) {
            this.trunkContainer.dispose();
            this.trunkContainer = null;
        }
        this.trunkGraphicImage = null;
        this.location = null;
        resources = null;
        this.trunkTableModel = null;
        this.portTableModel = null;
        this.jdmBrowser = null;
        this.chassis = null;
        this.chassisInfo = null;
        this.components.removeAllElements();
    }

    public void draw() {
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            try {
                leafCompositeLike.draw();
            }
            catch (Exception exception) {
                RAS.logInformation(19, 5, this, "draw", "Exception drawing object -> " + leafCompositeLike.getClass().getName());
                RAS.logException(19, 5, this, "draw", exception);
            }
        }
        this.graphicContainer.add(this.trunkContainer);
    }

    public final void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public GenModel getModel() {
        return this.trunkTableModel;
    }

    public ModelInfo getModelInfo() {
        return this.trunkInfo;
    }

    public String getDestinationPanel() {
        return DEST_PANEL;
    }

    public final void setCommonInformation(ChassisLike chassisLike, ChassisInfoLike chassisInfoLike, JdmBrowser jdmBrowser, ModelInfo modelInfo, GenModel genModel, GenModel genModel2, GraphicContainer graphicContainer, int n, int n2) {
        this.chassis = chassisLike;
        this.chassisInfo = chassisInfoLike;
        this.jdmBrowser = jdmBrowser;
        this.trunkTableModel = genModel;
        this.trunkInfo = modelInfo;
        this.portTableModel = genModel2;
        this.graphicContainer = graphicContainer;
        this.trunkSlotIndex = n;
        this.trunkIndex = n2;
    }

    public void setSpecificInformation() {
    }

    public void discoverChildren() {
        PortLike portLike = this.builder.buildPort(this.jdmBrowser, this.chassis, this.trunkContainer, this.trunkSlotIndex, 17, this.portTableModel);
        this.add(portLike);
        TrunkPortLike trunkPortLike = this.builder.buildTrunkPort(this.jdmBrowser, this.chassis, this.chassisInfo, this.trunkContainer, this.trunkTableModel, this.trunkInfo, this.trunkType, this.trunkSlotIndex, 3);
        this.add(trunkPortLike);
        int n = this.trunkIndex;
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Index.TrunkSlotIndex", new Integer(this.trunkSlotIndex));
        modelInfo.add("Index.TrunkIndex", new Integer(n + 1));
        TrunkPortLike trunkPortLike2 = this.builder.buildTrunkPort(this.jdmBrowser, this.chassis, this.chassisInfo, this.trunkContainer, this.trunkTableModel, modelInfo, this.trunkType, this.trunkSlotIndex, 4);
        this.add(trunkPortLike2);
    }

    public final void setLocation(Point point) {
        this.location = point;
        this.trunkContainer.setLocation(this.location.x, this.location.y);
    }
}

